const getPost = function(fastify) {
  return (request, reply) => {
    try {
      const decodedToken = fastify.getTokenDecoded(request, reply);
      if (decodedToken) {
        fastify.mysql.getConnection(onConnect);

        function onConnect(err, client) {
          if (err) return reply.send(err);

          client.query(
            `SELECT p.post_public_id, p.post_title, p.post_text, p.post_date_create, u.user_public_id
            FROM users u, posts p 
            WHERE p.user_id = u.user_id AND p.post_public_id=?`,
            [request.params.post_public_id],
            function onResult(err, result) {
              client.release();
              if (err) {
                reply.send(err);
              } else if (result && result.length > 0) {
                reply.send(result[0]);
              }
            }
          );
        }
      }
    } catch (err) {
      reply.send(err);
    }
  };
};

const getMyPosts = function(fastify) {
    return (request, reply) => {
      try {
        const decodedToken = fastify.getTokenDecoded(request, reply);
        if (decodedToken) {
          fastify.mysql.getConnection(onConnect);
  
          function onConnect(err, client) {
            if (err) return reply.send(err);
  
            client.query(
              `SELECT p.post_public_id, p.post_title, p.post_text, p.post_date_create, u.user_public_id
              FROM users u, posts p 
              WHERE p.user_id = u.user_id AND u.user_public_id=?`,
              [decodedToken["user_public_id"]],
              function onResult(err, result) {
                client.release();
                if (err) {
                  reply.send(err);
                } else {
                  reply.send(result);
                }
              }
            );
          }
        }
      } catch (err) {
        reply.send(err);
      }
    };
  };

const createPost = function(fastify) {
  return (request, reply) => {
    try {
      const decodedToken = fastify.getTokenDecoded(request, reply);
      if (decodedToken) {
        //console.log('decoded: ', decodedToken);

        fastify.mysql.getConnection(onConnect);

        function onConnect(err, client) {
          if (err) return reply.send(err);

          const { post_title, post_text } = request.body;

          client.query(
            `INSERT INTO posts (post_title, post_text, user_id, post_public_id) VALUES(?, ?, ?, UUID())`,
            [post_title, post_text, decodedToken["user_id"]],
            function onResult(err, result) {
              client.release();
              reply.send(err || result[0]);
            }
          );
        }
      }
    } catch (err) {
      reply.send(err);
    }
    //reply.send({result: 'ok'});
  };
};

const editPost = function(fastify) {
  return (request, reply) => {
    try {
      const decodedToken = fastify.getTokenDecoded(request, reply);
      if (decodedToken) {
        //console.log('decoded: ', decodedToken);

        fastify.mysql.getConnection(onConnect);

        function onConnect(err, client) {
          if (err) return reply.send(err);

          const { post_title, post_text, post_public_id } = request.body;

          client.query(
            `UPDATE posts SET post_title=?, post_text=? WHERE post_public_id=?`,
            [post_title, post_text, post_public_id],
            function onResult(err, result) {
              client.release();
              if (err) {
                fastify.BadRequest(request, reply, err);
              } else if (result && result.affectedRows === 1) {
                reply.send({ result: "ok" });
              } else {
                fastify.LoginError(request, reply);
              }
            }
          );
        }
      }
    } catch (err) {
      reply.send(err);
    }
    //reply.send({result: 'ok'});
  };
};

const deletePost = function(fastify) {
  return (request, reply) => {
    try {
      const decodedToken = fastify.getTokenDecoded(request, reply);
      if (decodedToken) {
        //console.log('decoded: ', decodedToken);

        fastify.mysql.getConnection(onConnect);

        function onConnect(err, client) {
          if (err) return reply.send(err);

          const { post_public_id } = request.body;

          client.query(
            `DELETE FROM posts WHERE post_public_id=? AND user_id=?`,
            [post_public_id, decodedToken["user_id"]],
            function onResult(err, result) {
              client.release();
              if (err) {
                fastify.BadRequest(request, reply, err);
              } else if (result && result.affectedRows === 1) {
                reply.send({ result: "ok" });
              } else {
                fastify.LoginError(request, reply);
              }
            }
          );
        }
      }
    } catch (err) {
      reply.send(err);
    }
    //reply.send({result: 'ok'});
  };
};

module.exports = {
  getPost,
  getMyPosts,
  createPost,
  editPost,
  deletePost
};
